
/**
 ******************************************************************************
 *
 * @file        MG0402_BSP.c
 * @brief       MG0404 Board Support routine. 
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG0402_BSP.h"
#include "MG32x02z_EncoderEC11_API.h"

/* Exported functions --------------------------------------------------------*/
extern void API_DS1621_Init(void);

/* Exported variables --------------------------------------------------------*/

/* Private typedef -----------------------------------------------------------*/

/* Private define ------------------------------------------------------------*/

/* Private macro -------------------------------------------------------------*/

/* Private variables ---------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/
DMA_HandleTypeDef mDMA_ADC;
DMA_HandleTypeDef mDMA_DAC;
DMA_HandleTypeDef mDMA_USB;

SPI_HandleTypeDef mSPI0;
DMA_HandleTypeDef mDMA_SPI0RX;  // SPI0 RX to Memory EMB
DMA_HandleTypeDef mDMA_SPI0Rx_to_URT0Tx; // SPI0 RX to URT0 SPI Mode
EMB_HandleTypeDef mEMB;
SPI_HandleTypeDef mURT0SPI;

RTC_HandleTypeDef mRTC;
I2C_HandleTypeDef mI2C1;
URT_HandleTypeDef mURT4;
EXIC_HandleTypeDef mEXIC_PA;

//void BSP_GPIO_Init()
//{
////    GPIO_InitTypeDef mGPIO;

////  // ICKO
////    mGPIO.Pin           = CLKOUT_ICKO_Pin;
////    mGPIO.Alternate     = CLKOUT_ICKO_AFS;
////    mGPIO.Mode          = GPIO_MODE_PUSHPULL_O;
////    mGPIO.Pull          = GPIO_NOPULLUP;
////    mGPIO.Speed         = GPIO_SPEED_HIGH;
////    mGPIO.Inverse       = GPIO_INVERSE_DISABLE;
////    mGPIO.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;
////    mGPIO.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;
////    MID_GPIO_Init(CLKOUT_ICKO_Port, &mGPIO);

////  // LCD 
////    // LCD BL
////    mGPIO.Pin           = (LCD1st_BL_Pin | LCD2nd_BL_Pin);
////    mGPIO.Alternate     = LCD1st_BL_AFS;
////    mGPIO.Mode          = LCD1st_BL_Mode;
////    MID_GPIO_Init(LCD1st_BL_Port, &mGPIO);

////    // LCD RSTN
////    mGPIO.Pin           = LCD_RSTN_Pin;
////    mGPIO.Alternate     = LCD_RSTN_AFS;
////    mGPIO.Mode          = LCD_RSTN_Mode;
////    MID_GPIO_Init(LCD_RSTN_Port, &mGPIO);

////  // LCD 1st use EMB
////    // DB0[0:7] DIN
////    mGPIO.Pin           = (LCD1st_D0_Pin | LCD1st_D1_Pin | LCD1st_D2_Pin | LCD1st_D3_Pin | LCD1st_D4_Pin | LCD1st_D5_Pin | LCD1st_D6_Pin | LCD1st_D7_Pin);
////    mGPIO.Alternate     = LCD1st_D0_7_AFS;
////    mGPIO.Mode          = LCD1st_D0_7_Mode;
////    MID_GPIO_Init(LCD1st_D0_7_Port, &mGPIO);

////    // DB[8:15] DIN
////    mGPIO.Pin           = (LCD1st_D8_Pin | LCD1st_D9_Pin | LCD1st_D10_Pin | LCD1st_D11_Pin | LCD1st_D12_Pin | LCD1st_D13_Pin | LCD1st_D14_Pin | LCD1st_D15_Pin);
////    mGPIO.Alternate     = LCD1st_D8_15_AFS;
////    mGPIO.Mode          = LCD1st_D8_15_Mode;
////    MID_GPIO_Init(LCD1st_D8_15_Port, &mGPIO);

////    // MCS, MRD, MWR
////    mGPIO.Pin           = (LCD1st_RD_Pin | LCD1st_WR_Pin | LCD1st_CS_Pin);
////    mGPIO.Alternate     = LCD1st_CTL_AFS;
////    mGPIO.Mode          = LCD1st_CTL_Mode;
////    MID_GPIO_Init(LCD1st_CTL_Port, &mGPIO);

////    // RS / DC
////    mGPIO.Pin           = LCD1st_RS_Pin;
////    mGPIO.Alternate     = LCD1st_RS_AFS;
////    mGPIO.Mode          = LCD1st_RS_Mode;
////    MID_GPIO_Init(LCD1st_RS_Port, &mGPIO);

////  // LCD 2nd use URT0
////    // DO, CLK, CSn
////    mGPIO.Pin           = (LCD2nd_URT0SPI_SDO_Pin | LCD2nd_URT0SPI_SCK_Pin | LCD2nd_URT0SPI_CS2_Pin);
////    mGPIO.Alternate     = LCD2nd_URT0SPI_AFS;
////    mGPIO.Mode          = LCD2nd_URT0SPI_Mode;
////    MID_GPIO_Init(LCD2nd_URT0SPI_Port, &mGPIO);

////    // DI
////    mGPIO.Pin           = LCD2nd_URT0SPI_SDI_Pin;
////    mGPIO.Alternate     = LCD2nd_URT0SPI_AFS;
////    mGPIO.Mode          = LCD2nd_URT0SPI_SDI_Mode;
////    MID_GPIO_Init(LCD2nd_URT0SPI_Port, &mGPIO);

//  // USB

////  // Flash use SPI0
////    // CEn
////    mGPIO.Pin           = FLASH_SPI0_CEN_Pin;
////    mGPIO.Alternate     = FLASH_SPI0_CEN_AFS;
////    mGPIO.Mode          = FLASH_SPI0_Mode;
////    MID_GPIO_Init(FLASH_SPI0_Port, &mGPIO);

////    // SCK, DO, D3, 
////    mGPIO.Pin           = (FLASH_SPI0_SCK_Pin | FLASH_SPI0_DO_Pin | FLASH_SPI0_D3_Pin);
////    mGPIO.Alternate     = FLASH_SPI0_AFS;
////    mGPIO.Mode          = FLASH_SPI0_Mode;
////    MID_GPIO_Init(FLASH_SPI0_Port, &mGPIO);

////    // D2
////    mGPIO.Pin           = (FLASH_SPI0_D2_Pin | FLASH_SPI0_DI_Pin);
////    mGPIO.Alternate     = FLASH_SPI0_AFS_B;
////    MID_GPIO_Init(FLASH_SPI0_Port, &mGPIO);

//  // BLE
////    mGPIO.Pin           = (BLE_SPI_CSN_Pin | BLE_SPI_SCK_Pin | BLE_SPI_DO_Pin);
////    mGPIO.Alternate     = BLE_SPI_AFS;
////    mGPIO.Mode          = BLE_SPI_Mode;
////    MID_GPIO_Init(BLE_SPI_Port, &mGPIO);

////    mGPIO.Pin           = BLE_SPI_DI_Pin;
////    mGPIO.Mode          = BLE_SPI_DI_Mode;
////    MID_GPIO_Init(BLE_SPI_Port, &mGPIO);

////    mGPIO.Pin           = BLE_IRQ_EXIC_Pin;
////    mGPIO.Alternate     = BLE_IRQ_EXIC_AFS;
////    mGPIO.Mode          = BLE_IRQ_EXIC_Mode;
////    MID_GPIO_Init(BLE_IRQ_EXIC_Port, &mGPIO);

////  // RGB LED
////    mGPIO.Pin           = (RGBLED1st_TM36_R_Pin | RGBLED1st_TM36_G_Pin | RGBLED1st_TM36_B_Pin);
////    mGPIO.Alternate     = RGBLED1st_TM36_AFS;
////    mGPIO.Mode          = RGBLED1st_TM36_Mode;
////    MID_GPIO_Init(RGBLED1st_TM36_Port, &mGPIO);

////  // EEPROM
////    mGPIO.Pin           = (EEPROM_I2C1_SDA_Pin | EEPROM_I2C1_SCL_Pin);
////    mGPIO.Alternate     = EEPROM_I2C1_AFS;
////    mGPIO.Mode          = EEPROM_I2C1_Mode;
////    MID_GPIO_Init(EEPROM_I2C1_Port, &mGPIO);

////  // AUDIO OUT
////    mGPIO.Pin           = (AUDIO_DAC_OUTL_Pin | AUDIO_DAC_OUTR_Pin);
////    mGPIO.Alternate     = AUDIO_DAC_AFS;
////    mGPIO.Mode          = AUDIO_DAC_Mode;
////    MID_GPIO_Init(AUDIO_DAC_Port, &mGPIO);

////  // AUDIO IN
////    mGPIO.Pin           = (AUDIO_ADC_INL_Pin | AUDIO_ADC_INR_Pin);
////    mGPIO.Alternate     = AUDIO_ADC_AFS;
////    mGPIO.Mode          = AUDIO_ADC_Mode;
////    MID_GPIO_Init(AUDIO_ADC_Port, &mGPIO);

////  // EC11
////    // A, B
////    mGPIO.Pin           = (EC11_TM36_A_Pin | EC11_TM36_B_Pin);
////    mGPIO.Alternate     = EC11_TM36_AFS;
////    mGPIO.Mode          = EC11_TM36_Mode;
////    MID_GPIO_Init(EC11_TM36_Port, &mGPIO);

////    // SW
////    mGPIO.Pin           = EC11_EXIC_SW_Pin;
////    mGPIO.Alternate     = EC11_EXIC_AFS;
////    mGPIO.Mode          = EC11_TM36_Mode;
////    MID_GPIO_Init(EC11_TM36_Port, &mGPIO);

////  // IR
////    // TX
////    mGPIO.Pin           = IR_APB_TX_Pin;
////    mGPIO.Alternate     = IR_APB_TX_AFS;
////    mGPIO.Mode          = IR_APB_TX_Mode;
////    MID_GPIO_Init(IR_APB_Port, &mGPIO);

////    // RX use TM10
////    mGPIO.Pin           = IR_APB_RX_Pin;
////    mGPIO.Alternate     = IR_APB_RX_AFS;
////    mGPIO.Mode          = IR_APB_RX_Mode;
////    MID_GPIO_Init(IR_APB_Port, &mGPIO);

////  // Debug from URT4
////    // URT TX
////    mGPIO.Pin           = URT4_TX_Pin;
////    mGPIO.Alternate     = URT4_AFS;
////    mGPIO.Mode          = URT4_TX_Mode;
////    MID_GPIO_Init(URT4_Port, &mGPIO);

////    // URT RX
////    mGPIO.Pin           = URT4_RX_Pin;
////    mGPIO.Mode          = URT4_RX_Mode;
////    MID_GPIO_Init(URT4_Port, &mGPIO);

////  // Debug for GPIO PE12 / 13 / 14 / 15 / PC13 / 14
////    PE12 = PE13 = PE14 = PE15 = PC13 = PC14 = 0;
////    mGPIO.Pin           = GPIO_Pin_12 | GPIO_Pin_13 | GPIO_Pin_14 | GPIO_Pin_15;
////    mGPIO.Alternate     = 0;
////    mGPIO.Mode          = GPIO_MODE_PUSHPULL_O;
////    MID_GPIO_Init(IOME, &mGPIO);

////    mGPIO.Pin           = GPIO_Pin_13 | GPIO_Pin_14;
////    MID_GPIO_Init(IOMC, &mGPIO);

////  // ARGB LED
////    mGPIO.Pin           = ARGBLED_URT_OUT_Pin;
////    mGPIO.Alternate     = ARGBLED_URT_OUT_AFS;
////    mGPIO.Mode          = ARGBLED_URT_OUT_Mode;
////    MID_GPIO_Init(ARGBLED_URT_OUT_Port, &mGPIO);
//}

//void LCD_Interface(void)
//{
//    PINB(8)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINB(9)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINB(10)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINB(11)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINB(12)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINB(13)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINB(14)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINB(15)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;

//    PINC(1)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINC(2)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINC(3)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINC(8)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINC(9)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINC(10)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINC(11)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;
//    PINC(12)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;

//    //LCD_RS
//    PINC(7)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;

//    //LCD_CS
//    PINB(7)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;

//    //LCD_WR
//    PINB(6)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;

//    //LCD_RD
//    PINB(5)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;

//    //LCD_RSTN
//    PINB(4)->CR.W = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af8_w;

//    //uint16_t ltemp;
//    // EMB Config
//    EMB->CR0.W &= (~EMB_CR0_EN_mask_w);
//    EMB->CLK.W = (1 << EMB_CLK_CK_PSC_shift_w);
//    EMB->CR0.W = ((uint32_t)0x00000100) |   //EMB_CR0_BUS_DSIZE_16_bit_w |
//                 EMB_CR0_WEN_mask_w |
//                 ((uint32_t)0x00000004) |   // EMB_CR0_BW_EN_mask_w
//                 //EMB_CR0_SYNC_EN_mask_w |
//                 //EMB_CR0_BUS_MDS_multiplex_w |
//                 EMB_CR0_BUS_MDS_separated_w |
//                 //EMB_CR0_ADR_TWO_mask_w |
//                 //EMB_CR0_ADR_SEL_16bit_w |
//                 //EMB_CR0_ADR_SEL_24bit_w |
//                 //EMB_CR0_ADR_SEL_30bit_w |
//                 //EMB_CR0_ALE2_MDS_ale_w |
//                 //EMB_CR0_ALE2_MDS_ale2_w |
//                 //EMB_CR0_OE_CTL_mask_w |
//                 //EMB_CR0_WE_CTL_mask_w |
//                 //EMB_CR0_DMA_EN_mask_w |
//                 0;
//    EMB->CR1.W = //EMB_CR1_CE_INV_mask_w |
//                 //EMB_CR1_ALE_INV_mask_w |
//                 //EMB_CR1_ALE2_INV_mask_w |
//                 //EMB_CR1_CLK_INV_mask_w |
//                 //EMB_CR1_MA_SWAP_mask_w |
//                 //EMB_CR1_MAD_SWAP_mask_w |
//                 //EMB_CR1_MAD_BSWAP_mask_w |
//                 //EMB_CR1_MAM1_SEL_no_w |
//                 //EMB_CR1_MAM1_SEL_mad15_w |
//                 //EMB_CR1_MAM1_SEL_bw1_w |
//                 //EMB_CR1_MAM1_SEL_ale2_w |
//                 //EMB_CR1_CE_SWEN_mask_w |       // LCD CS >> PB7 AFS8 MCE
//                 //EMB_CR1_CE_SWO_mask_w |
//                 EMB_CR1_ALE_SWEN_mask_w |      // LCD RSTN >> PB4 AFS8 MALE
//                 EMB_CR1_ALE_SWO_mask_w |
//                 //EMB_CR1_ALE2_SWEN_mask_w |
//                 //EMB_CR1_ALE2_SWO_mask_w |
//                 EMB_CR1_BW0_SWEN_mask_w |      // LCD RS >> PC7 AFS8 MBW1
//                 //EMB_CR1_BW0_SWO_mask_w |
//                 //EMB_CR1_BW1_SWEN_mask_w |
//                 //EMB_CR1_BW1_SWO_mask_w |
//                 //EMB_CR1_OE_MUX_oe_w |
//                 //EMB_CR1_OE_MUX_tm10_w |
//                 //EMB_CR1_OE_MUX_tm16_w |
//                 //EMB_CR1_OE_MUX_tm20_w |
//                 //EMB_CR1_WE_MUX_we_w |
//                 //EMB_CR1_WE_MUX_tm10_w |
//                 //EMB_CR1_WE_MUX_tm16_w |
//                 //EMB_CR1_WE_MUX_tm20_w |
//                 0;
//    EMB->CR2.W = //EMB_CR2_ALES_mask_w |
//                 //(3 << EMB_CR2_ALEW_shift_w) |
//                 //EMB_CR2_ALEH_mask_w |
//                 EMB_CR2_ACCS_mask_w |
//                 (0 << 16) |
//                 //EMB_CR2_ACCH_mask_w |
//                 //(1 << 24) |
//                 0;
//    EMB->CR0.W |= EMB_CR0_EN_mask_w;
//}


void DMACopyAgain(DMA_HandleTypeDef *mDMA)
{
    __DRV_DMA_DISABLE_ITEA(mDMA);
//    MID_DMA_Start(mDMA, (uint32_t ) &SrcData2, (uint32_t ) &DestArea, 10);
}

void BSP_DMA_Init()
{
//    mDMA.Instance = DMA;
//    mDMA.PriorityMode = DMA_LEVEL;
//    mDMA.ExtraGPL_Channel = NULL;

////-------------------------------------   // By SPI Flash
//  // SPI Read to EMB LCD
//    mDMA.DMAChannelIndex = DMAChannel2;
//    mDMA.Init.SrcPeri = MID_DMA_SPI0_READ;
//    mDMA.Init.DesPeri = MID_DMA_MEMORY_WRITE;
//    mDMA.Init.BSize = DMA_BSIZE_2BYTE;
//    mDMA.Init.LoopMode = DMA_LOOP_DISABLE;
//    mDMA.Init.Priority = DMA_PRIORITY_LOW;
//    mDMA.Init.MEMMode = MID_DMA_MEMORY_NORMAL;
//    MID_DMA_Init(&mDMA);

//    mDMA.XferCpltCallback = DMACopyAgain;

//    NVIC_EnableIRQ(DMA_IRQn);
//    MID_DMA_Start_IT(&mDMA, (uint32_t ) &SrcData, (uint32_t ) &DestArea, 10);

////-------------------------------------
//  // SPI Read to URT0 SPI LCD
//    mDMA.DMAChannelIndex = DMAChannel1;
//    mDMA.Init.SrcPeri = MID_DMA_SPI0_READ;
//    mDMA.Init.DesPeri = MID_DMA_URT0_WRITE;
//    mDMA.Init.BSize = DMA_BSIZE_1BYTE;
//    mDMA.Init.LoopMode = DMA_LOOP_DISABLE;
//    mDMA.Init.Priority = DMA_PRIORITY_LOW;
//    mDMA.Init.MEMMode = MID_DMA_MEMORY_NORMAL;
//    MID_DMA_Init(&mDMA);

//    mDMA.XferCpltCallback = DMACopyAgain;

//    NVIC_EnableIRQ(DMA_IRQn);
////    MID_DMA_Start_IT(&mDMA, (uint32_t ) &SrcData, (uint32_t ) &DestArea, 10);

////-------------------------------------
//    // ------------------------------------------------------------------------
//    // 3.Initial DMA. (P2M)
//    // ------------------------------------------------------------------------
//    mDMA.DMAChannelIndex = DMAChannel2;         // P2M
//    mDMA.Init.SrcPeri = MID_DMA_ADC0_SAMPLE;    // Source symbol is ADC
//    mDMA.Init.DesPeri = MID_DMA_MEMORY_WRITE;   // Destination symbol is Memory
//    mDMA.Init.BSize = DMA_BSIZE_2BYTE;          // Burst size is 4 byte
//    mDMA.Init.MEMMode = MID_DMA_MEMORY_NORMAL;  // Normal memory access mode
//    mDMA.Init.LoopMode = DMA_LOOP_ENABLE;       // ENABLE Loop mode
//    mDMA.Parent = &mADC;
//    MID_DMA_Init(&mDMA);
}

void BSP_Interrupt_Init(void)
{
    //MID_NVIC_SetPriority(SysTick_IRQn, 0);
    //MID_NVIC_SetPriority(SYS_IRQn, 1);
    MID_NVIC_SetPriority(USB_IRQn, 1);
    MID_NVIC_SetPriority(SPI0_IRQn, 1);
    MID_NVIC_SetPriority(EXINT0_IRQn, 2);
    MID_NVIC_SetPriority(TM20_IRQn, 2);
    MID_NVIC_SetPriority(TM3x_IRQn, 2);
    //MID_NVIC_SetPriority(EXINT1_IRQn, 2);
    //MID_NVIC_SetPriority(EXINT2_IRQn, 2);
    //MID_NVIC_SetPriority(EXINT3_IRQn, 2);
    MID_NVIC_SetPriority(DMA_IRQn, 3);

    //MID_NVIC_EnableIRQ(SysTick_IRQn);
    //MID_NVIC_EnableIRQ(SYS_IRQn);
    MID_NVIC_EnableIRQ(USB_IRQn);
    MID_NVIC_EnableIRQ(SPI0_IRQn);
    MID_NVIC_EnableIRQ(EXINT0_IRQn);
    MID_NVIC_EnableIRQ(TM3x_IRQn);
    MID_NVIC_EnableIRQ(EXINT0_IRQn);
    //MID_NVIC_EnableIRQ(EXINT1_IRQn);
    //MID_NVIC_EnableIRQ(EXINT2_IRQn);
    //MID_NVIC_EnableIRQ(EXINT3_IRQn);
    MID_NVIC_EnableIRQ(DMA_IRQn);
}

void MID_MspInit(void)
{
    GPIO_InitTypeDef mGPIO;

  // ICKO
    mGPIO.Pin           = CLKOUT_ICKO_Pin;
    mGPIO.Alternate     = CLKOUT_ICKO_AFS;
    mGPIO.Mode          = GPIO_MODE_PUSHPULL_O;
    mGPIO.Pull          = GPIO_NOPULLUP;
    mGPIO.Speed         = GPIO_SPEED_HIGH;
    mGPIO.Inverse       = GPIO_INVERSE_DISABLE;
    mGPIO.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;
    mGPIO.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;
    MID_GPIO_Init(CLKOUT_ICKO_Port, &mGPIO);

    mGPIO.Mode          = GPIO_MODE_OPENDRAIN_O;
    mGPIO.Pin           = GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2;
    MID_GPIO_Init(IOMA, &mGPIO);

  // Debug for GPIO PE12 / 13 / 14 / 15 / PC13 / 14
    PE12 = PE13 = PE14 = PE15 = PC13 = PC14 = 1;
    mGPIO.Pin           = GPIO_Pin_12 | GPIO_Pin_13 | GPIO_Pin_14 | GPIO_Pin_15;
    mGPIO.Alternate     = 0;
    mGPIO.Mode          = GPIO_MODE_PUSHPULL_O;
    MID_GPIO_Init(IOME, &mGPIO);

    mGPIO.Pin           = GPIO_Pin_13 | GPIO_Pin_14;
    MID_GPIO_Init(IOMC, &mGPIO);

    MID_NVIC_SetPriority(SysTick_IRQn, 0, 0);
    MID_NVIC_SetPriority(SYS_IRQn, 1, 0);
    MID_NVIC_SetPriority(DMA_IRQn, 3, 0);

    MID_NVIC_EnableIRQ(SysTick_IRQn);
    MID_NVIC_EnableIRQ(SYS_IRQn);
    MID_NVIC_SetPriority(DMA_IRQn, 3, 0);
}

//void BSP_CSC_Init()
//{
//}

void MID_EXIC_MspInit( EXIC_HandleTypeDef* MEXIC_PX)
{
    GPIO_InitTypeDef mEXICEC11_GPIO;

    mEXICEC11_GPIO.Pull          = GPIO_NOPULLUP;
    mEXICEC11_GPIO.Speed         = GPIO_SPEED_HIGH;
    mEXICEC11_GPIO.Inverse       = GPIO_INVERSE_DISABLE;
    mEXICEC11_GPIO.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;
    mEXICEC11_GPIO.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;

  // EC11
    // SW
    mEXICEC11_GPIO.Pin           = EC11_EXIC_SW_Pin;
    mEXICEC11_GPIO.Alternate     = EC11_EXIC_AFS;
    mEXICEC11_GPIO.Mode          = EC11_TM36_Mode;
    MID_GPIO_Init(EC11_TM36_Port, &mEXICEC11_GPIO);
}

void BSP_EXIC_Init(void)
{
    //EXIC Inital

    mEXIC_PA.Instance    = EXIC_PA;               // Set mEXIC_PA to control external PortA input interrupt.
    mEXIC_PA.AND_Mask    = EXIC_PX_PIN14;                  // Set AND mask = 0x03 ( If PA0 & PA1 trigger event happen at the same time , into interrupt. 
    mEXIC_PA.OR_Mask     = 0x00;                  // Set OR mask = 0x0C (If PA0 or PA1 trigger event happen , into interrupt.
    mEXIC_PA.AND_UnMatch = DISABLE;               // Disable AND flag status inverse. 
    mEXIC_PA.Interrupt   = EXIC_INTERRUPT_ENABLE; // Enable Interrupt.

    MID_EXIC_PxTriggerMode_Config(&mEXIC_PA, EXIC_TRGS_PIN14, EXIC_TRIGGER_LEVEL);   // PA14 trigger event = falling edge.
    MID_EXIC_PxTrigger_Init(&mEXIC_PA);
}

void MID_EMB_MspInit(EMB_HandleTypeDef* mEMB)
{
    GPIO_InitTypeDef mEMB_GPIO;

    mEMB_GPIO.Pull          = GPIO_NOPULLUP;
    mEMB_GPIO.Speed         = GPIO_SPEED_HIGH;
    mEMB_GPIO.Inverse       = GPIO_INVERSE_DISABLE;
    mEMB_GPIO.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;
    mEMB_GPIO.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;

  // LCD 
    // LCD BL
    mEMB_GPIO.Pin           = (LCD1st_BL_Pin | LCD2nd_BL_Pin);
    mEMB_GPIO.Alternate     = LCD1st_BL_AFS;
    mEMB_GPIO.Mode          = LCD1st_BL_Mode;
    MID_GPIO_Init(LCD1st_BL_Port, &mEMB_GPIO);

    // LCD RSTN
    mEMB_GPIO.Pin           = LCD_RSTN_Pin;
    mEMB_GPIO.Alternate     = LCD_RSTN_AFS;
    mEMB_GPIO.Mode          = LCD_RSTN_Mode;
    MID_GPIO_Init(LCD_RSTN_Port, &mEMB_GPIO);

  // LCD 1st use EMB
    // DB0[0:7] DIN
    mEMB_GPIO.Pin           = (LCD1st_D0_Pin | LCD1st_D1_Pin | LCD1st_D2_Pin | LCD1st_D3_Pin | LCD1st_D4_Pin | LCD1st_D5_Pin | LCD1st_D6_Pin | LCD1st_D7_Pin);
    mEMB_GPIO.Alternate     = LCD1st_D0_7_AFS;
    mEMB_GPIO.Mode          = LCD1st_D0_7_Mode;
    MID_GPIO_Init(LCD1st_D0_7_Port, &mEMB_GPIO);

    // DB[8:15] DIN
    mEMB_GPIO.Pin           = (LCD1st_D8_Pin | LCD1st_D9_Pin | LCD1st_D10_Pin | LCD1st_D11_Pin | LCD1st_D12_Pin | LCD1st_D13_Pin | LCD1st_D14_Pin | LCD1st_D15_Pin);
    mEMB_GPIO.Alternate     = LCD1st_D8_15_AFS;
    mEMB_GPIO.Mode          = LCD1st_D8_15_Mode;
    MID_GPIO_Init(LCD1st_D8_15_Port, &mEMB_GPIO);

    // MCS, MRD, MWR
    mEMB_GPIO.Pin           = (LCD1st_RD_Pin | LCD1st_WR_Pin | LCD1st_CS_Pin);
    mEMB_GPIO.Alternate     = LCD1st_CTL_AFS;
    mEMB_GPIO.Mode          = LCD1st_CTL_Mode;
    MID_GPIO_Init(LCD1st_CTL_Port, &mEMB_GPIO);

    // RS / DC
    mEMB_GPIO.Pin           = LCD1st_RS_Pin;
    mEMB_GPIO.Alternate     = LCD1st_RS_AFS;
    mEMB_GPIO.Mode          = LCD1st_RS_Mode;
    MID_GPIO_Init(LCD1st_RS_Port, &mEMB_GPIO);
}

void BSP_LCD_EMB_Init(void)
{
    mEMB.Instance = EMB;
    mEMB.Init.DeviceAccess = EMB_DEVICE_ACCESS_ASYNCHRONOUS;
    mEMB.Init.WriteSignal = EMB_WRITE_SIGNAL_TOGGLE;
    mEMB.Init.ReadSignal = EMB_READ_SIGNAL_TOGGLE;
    mEMB.Init.DataAddressMux = EMB_DATA_ADDRESS_MUX_DISABLE;
    mEMB.Init.DataAddressMuxMode = EMB_DATA_ADDRESS_MULTIPLEX_1ALE;
    mEMB.Init.AddressRange = EMB_ADDRESS_RANGE_16BIT;
    mEMB.Init.WriteAccess = EMC_WRITE_ACCESS_ENABLE;
  #if defined(MG32_3RD)
    mEMB.Init.DeviceDataWidth = EMB_DEVICE_DATA_BUS_WIDTH_16;
    mEMB.Init.AddressMAM1 = EMB_ADDRESS_MAM1_SIGNAL_DISABLE;
    mEMB.Init.WriteByteAccess = EMB_WRITE_BYTE_ACCESS_DISABLE;
    mEMB.Extended.MADBusByteSwap = EMB_MAD_BYTE_SWAP_DISABLE;
    mEMB.Extended.MADBusReverse = EMB_MAD_REVERSE_DISABLE;
  #endif
    mEMB.Extended.MABusReverse = EMB_MA_REVERSE_DISABLE;
    mEMB.Extended.MCLK_Inverse = EMB_MCLK_INVERSE_DISABLE;
    mEMB.Extended.MALE2_Inverse = EMB_MALE2_INVERSE_DISABLE;
    mEMB.Extended.MALE_Inverse = EMB_MALE_INVERSE_DISABLE;
    mEMB.Extended.MCE_Inverse = EMB_MCE_INVERSE_DISABLE;
    mEMB.CLKPrescaler = 1;
    mEMB.AddressSetupTime = 0;
    mEMB.AddressPulseTime = 1;
    mEMB.AddressHoldTime = 0;
    mEMB.DataSetupTime = 1;
    mEMB.DataAccessTime = 2;
    mEMB.DataHoldTime = 1;
    mEMB.IdleTime = 0;
    EMB_Init(&mEMB);
}

void BSP_RTC_Init(void)
{
    mRTC.Instance = RTC;
    mRTC.Init.RTC_CK_SEL = RTC_CLK_LS;         //RTC clock source select
    mRTC.Init.RTC_RLR = 0x00000000;             //RTC reload register set 0~0xFFFFFFFE, 0xFFFFFFFF  forbidden.
    mRTC.Init.HourFormat = RTC_HOURFORMAT_12;
    mRTC.sDate.Year = 2021U;
    mRTC.sDate.Month = April;
    mRTC.sDate.Date = 14U;
    mRTC.sTime.Hours = 21U;
    mRTC.sTime.Minutes = 23U;
    mRTC.sTime.Seconds = 00U;
    MID_RTC_Init(&mRTC);

    __DRV_RTC_WRITEPROTECT_DISABLE(&mRTC);
    __DRV_RTC_ENABLE_IT(&mRTC, RTC_IT_PC);
    __DRV_RTC_WRITEPROTECT_ENABLE(&mRTC);
}

void MID_RTC_MspInit(RTC_HandleTypeDef* mRTC)
{
    
}

void MID_TM_Encoder_MspInit(TM_HandleTypeDef* mTM)
{
    GPIO_InitTypeDef mTM36EC11_GPIO;

    mTM36EC11_GPIO.Pull          = GPIO_NOPULLUP;
    mTM36EC11_GPIO.Speed         = GPIO_SPEED_HIGH;
    mTM36EC11_GPIO.Inverse       = GPIO_INVERSE_DISABLE;
    mTM36EC11_GPIO.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;
    mTM36EC11_GPIO.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;

    if(mTM->Instance == TM36)
    {
      // EC11
        // A, B
        mTM36EC11_GPIO.Pin           = (EC11_TM36_A_Pin | EC11_TM36_B_Pin);
        mTM36EC11_GPIO.Alternate     = EC11_TM36_AFS;
        mTM36EC11_GPIO.Mode          = EC11_TM36_Mode;
        MID_GPIO_Init(EC11_TM36_Port, &mTM36EC11_GPIO);

        MID_NVIC_SetPriority(TM3x_IRQn, 2);
        MID_NVIC_EnableIRQ(EXINT3_IRQn);
    }
}

void MID_URT_MspInit(URT_HandleTypeDef* MURT)
{
    GPIO_InitTypeDef mURT_GPIO;

    mURT_GPIO.Pull          = GPIO_NOPULLUP;
    mURT_GPIO.Speed         = GPIO_SPEED_HIGH;
    mURT_GPIO.Inverse       = GPIO_INVERSE_DISABLE;
    mURT_GPIO.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;
    mURT_GPIO.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;

//    if(MURT->Instance == URT0)
//    {
//        // Clcok Config
//        // GPIO Config
//        // DMA Channel Config
//        // Interrupt Config
//    }
//    if(MURT->Instance == URT1)
//    {
//        // Clcok Config
//        // GPIO Config
//        // DMA Channel Config
//        // Interrupt Config
//    }
//    if(MURT->Instance == URT2)
//    {
//        // Clcok Config
//        // GPIO Config
//        // DMA Channel Config
//        // Interrupt Config
//    }
    if(MURT->Instance == URT4) // for Debug on GPIO PE0 / 1
    {
        // URT TX
        mURT_GPIO.Pin           = URT4_TX_Pin;
        mURT_GPIO.Alternate     = URT4_AFS;
        mURT_GPIO.Mode          = URT4_TX_Mode;
        MID_GPIO_Init(URT4_Port, &mURT_GPIO);

        // URT RX
        mURT_GPIO.Pin           = URT4_RX_Pin;
        mURT_GPIO.Mode          = URT4_RX_Mode;
        MID_GPIO_Init(URT4_Port, &mURT_GPIO);
    }
}

void BSP_URT_Init(void)
{
    mURT4.Instance = URT4;
    mURT4.Init.Mode = URT_TX_RX;
    mURT4.Init.BaudRate = 921600;
//    mURT4.Init.BaudRate = 115200;
//    mURT4.Init.BaudRate = 57600;
//    mURT4.Init.BaudRate = 9600;
//    mURT4.Init.BaudRate = 4800;
//    mURT4.Init.BaudRate = 1200;
    mURT4.Init.WordLength = UART_WORDLENGTH_8B;
    mURT4.Init.Parity = URT_PARITY_NO;
    mURT4.Init.StopBits = URT_STOPBIT_1_0;
    mURT4.Init.HWFlowCtrl = URT_HWCONTROL_NONE;
    mURT4.Init.OneBitSampling = URT_ONEBIT_SAMPLE_SINGLE;
    mURT4.AdvancedInit.AdvFeatureInit = URT_ADVFEATURE_NO_INIT;
    MID_URT_Init(&mURT4);
}


void MID_SPI_MspInit(SPI_HandleTypeDef *mSPI)
{
    GPIO_InitTypeDef mSPIFlash_GPIO;

    mSPIFlash_GPIO.Pull          = GPIO_NOPULLUP;
    mSPIFlash_GPIO.Speed         = GPIO_SPEED_HIGH;
    mSPIFlash_GPIO.Inverse       = GPIO_INVERSE_DISABLE;
    mSPIFlash_GPIO.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;
    mSPIFlash_GPIO.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;

    if(mSPI->Instance == SPI_SPI0)
    {
      // Flash use SPI0
        // CEn
        mSPIFlash_GPIO.Pin = FLASH_SPI0_CEN_Pin;
        mSPIFlash_GPIO.Alternate = FLASH_SPI0_CEN_AFS;
        mSPIFlash_GPIO.Mode = FLASH_SPI0_Mode;
        MID_GPIO_Init(FLASH_SPI0_Port, &mSPIFlash_GPIO);

        // SCK, DO, D3, 
        mSPIFlash_GPIO.Pin = (FLASH_SPI0_SCK_Pin | FLASH_SPI0_DO_Pin | FLASH_SPI0_D3_Pin);
        mSPIFlash_GPIO.Alternate = FLASH_SPI0_AFS;
        mSPIFlash_GPIO.Mode = FLASH_SPI0_Mode;
        MID_GPIO_Init(FLASH_SPI0_Port, &mSPIFlash_GPIO);

        // D2
        mSPIFlash_GPIO.Pin = (FLASH_SPI0_D2_Pin | FLASH_SPI0_DI_Pin);
        mSPIFlash_GPIO.Alternate     = FLASH_SPI0_AFS_B;
        MID_GPIO_Init(FLASH_SPI0_Port, &mSPIFlash_GPIO);
    }

    if(mSPI->Instance == SPI_URT0)
    {
      // LCD 2nd use URT0
        // DO, CLK, CSn
        mSPIFlash_GPIO.Pin           = (LCD2nd_URT0SPI_SDO_Pin | LCD2nd_URT0SPI_SCK_Pin | LCD2nd_URT0SPI_CS2_Pin);
        mSPIFlash_GPIO.Alternate     = LCD2nd_URT0SPI_AFS;
        mSPIFlash_GPIO.Mode          = LCD2nd_URT0SPI_Mode;
        MID_GPIO_Init(LCD2nd_URT0SPI_Port, &mSPIFlash_GPIO);

        // DI
        mSPIFlash_GPIO.Pin           = LCD2nd_URT0SPI_SDI_Pin;
        mSPIFlash_GPIO.Alternate     = LCD2nd_URT0SPI_AFS;
        mSPIFlash_GPIO.Mode          = LCD2nd_URT0SPI_SDI_Mode;
        MID_GPIO_Init(LCD2nd_URT0SPI_Port, &mSPIFlash_GPIO);
    }
}

void BSP_SPI_Init(void)
{
//    mSPI0.Instance = SPI_SPI0;
//    mSPI0.Init.Mode = SPI_MODE_MASTER_NSS;
//    mSPI0.Init.NSSPMode = SPI_NSS_PULSE_DISABLE;
//    mSPI0.Init.NSS = SPI_NSS_HARDWARE;
//    mSPI0.Init.DataLine = SPI_STANDARD_SPI;
//    mSPI0.Init.DataSize = SPI_DATASIZE_8BIT;
//    mSPI0.Init.CLKPolarity = SPI_POLARITY_LOW;
//    mSPI0.Init.CLKPhase = SPI_PHASE_1EDGE;
//    mSPI0.Init.ClockDivider = SPI_CLOCKDIVIDER_4;
//    mSPI0.Init.FirstBit = SPI_FIRSTBIT_MSB;
//    mSPI0.Init.NSSPMode = SPI_NSS_PULSE_DISABLE;
//    if (MID_SPI_Init(&mSPI0) != MID_OK)                 // When SPI initial failure, stop at there.
//    {
//        while(1);
//    }

    mURT0SPI.Instance = SPI_URT0;
    mURT0SPI.Init.Mode = SPI_MODE_MASTER_NSS;
    mURT0SPI.Init.NSSPMode = SPI_NSS_PULSE_DISABLE;
    mURT0SPI.Init.NSS = SPI_NSS_OUT_HARDWARE;
    mURT0SPI.Init.DataLine = SPI_STANDARD_SPI;
    mURT0SPI.Init.DataSize = SPI_DATASIZE_8BIT;
    mURT0SPI.Init.CLKPolarity = SPI_POLARITY_LOW;
    mURT0SPI.Init.CLKPhase = SPI_PHASE_1EDGE;
    mURT0SPI.Init.ClockDivider = SPI_CLOCKDIVIDER_2;
    mURT0SPI.Init.FirstBit = SPI_FIRSTBIT_MSB;
    mURT0SPI.Init.NSSPMode = SPI_NSS_PULSE_DISABLE;
    if (MID_SPI_Init(&mURT0SPI) != MID_OK)                 // When SPI initial failure, stop at there.
    {
        while(1);
    }
    NVIC_DisableIRQ((IRQn_Type)mURT0SPI.SPI_IRQ);
    SPI0->CR0.MBIT.RX_CTL = 1;              // SPI RX at next edge.
}

void MID_I2C_MspInit(I2C_HandleTypeDef *mI2C)
{
    GPIO_InitTypeDef mI2CEEPROM_GPIO;

    mI2CEEPROM_GPIO.Pull          = GPIO_NOPULLUP;
    mI2CEEPROM_GPIO.Speed         = GPIO_SPEED_HIGH;
    mI2CEEPROM_GPIO.Inverse       = GPIO_INVERSE_DISABLE;
    mI2CEEPROM_GPIO.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;
    mI2CEEPROM_GPIO.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;

//    if(mI2C->Instance == I2C0)
//    {
//      // Clcok Config
//      // GPIO Config
//      // DMA Channel Config
//      // Interrupt Config
//    }

    if(mI2C->Instance == I2C1)
    {
      // Clcok Config
      // GPIO Config
        // EEPROM
        mI2CEEPROM_GPIO.Pin           = (EEPROM_I2C1_SDA_Pin | EEPROM_I2C1_SCL_Pin);
        mI2CEEPROM_GPIO.Alternate     = EEPROM_I2C1_AFS;
        mI2CEEPROM_GPIO.Mode          = EEPROM_I2C1_Mode;
        MID_GPIO_Init(EEPROM_I2C1_Port, &mI2CEEPROM_GPIO);
      // DMA Channel Config
      // Interrupt Config
    }
}

void BSP_I2C_Init(void)
{
    mI2C1.Instance = I2C1;
    mI2C1.Init.Timing = MID_I2C_GetInitTiming(&mI2C1, 1000000);
    mI2C1.Init.OwnAddress1 = 0x20;
    mI2C1.Init.DualAddressMode = I2C_DUALADDRESS_ENABLE;
    mI2C1.Init.OwnAddress2 = 0x80;
    mI2C1.Init.GeneralCallMode = I2C_GENERALCALL_ENABLE;
    MID_I2C_Init(&mI2C1);
}

void BSP_Init(void)
{
    // Chip
    MID_Init();

    // Debug use URT4
    BSP_URT_Init();

    // Initial
    // LCD use EMB 
    BSP_LCD_EMB_Init();

    // LCD use URT0(with SPI Mode)
    // Flash MX25 SPI0 QSPI Mode
    BSP_SPI_Init();     // URT0 SPI Mode and SPI0

    //__DRV_SYS_ENABLE_IT(SYS_INT_IEA_mask_w);
    SYS->INT.W = SYS_INT_IEA_mask_w;
    BSP_RTC_Init();

    // EEPROM I2C1 24C08
    BSP_I2C_Init();

    API_DS1621_Init();

    // Encoder EC11
    API_EncoderEC11_Init();
    BSP_EXIC_Init();

    // Interrupt, NVIC
    BSP_Interrupt_Init();
}


